% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R, R/ligerCommand_relates.R
\docType{class}
\name{ligerCommand-class}
\alias{ligerCommand-class}
\alias{ligerCommand}
\alias{show,ligerCommand-method}
\title{ligerCommand object: Record the input and time of a LIGER function call}
\usage{
\S4method{show}{ligerCommand}(object)
}
\arguments{
\item{object}{A \code{ligerCommand} object}
}
\description{
ligerCommand object: Record the input and time of a LIGER function call
}
\section{Slots}{

\describe{
\item{\code{funcName}}{Name of the function}

\item{\code{time}}{A time stamp object}

\item{\code{call}}{A character string converted from system call}

\item{\code{parameters}}{List of all arguments except the \linkS4class{liger} object.
Large object are summarized to short string.}

\item{\code{objSummary}}{List of attributes of the \linkS4class{liger} object as a
snapshot when command is operated.}

\item{\code{ligerVersion}}{Character string converted from
\code{packageVersion("rliger")}.}

\item{\code{dependencyVersion}}{Named character vector of version number, if any
dependency library has a chance to be included by the function. A
dependency might only be invoked under certain conditions, such as using
an alternative algorithm, which a call does not actually reach to, but it
would still be included for this call.}
}}

\examples{
pbmc <- normalize(pbmc)
cmd <- commands(pbmc, "normalize")
cmd
}
