% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotClusterGeneViolin}
\alias{plotClusterGeneViolin}
\title{Create violin plot for multiple genes grouped by clusters}
\usage{
plotClusterGeneViolin(
  object,
  gene,
  groupBy = NULL,
  colorBy = NULL,
  box = FALSE,
  boxAlpha = 0.1,
  yFunc = function(x) log1p(x * 10000),
  showLegend = !is.null(colorBy),
  xlabAngle = 40,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} object.}

\item{gene}{Character vector of gene names.}

\item{groupBy}{The name of an available categorical variable in
\code{cellMeta} slot. This forms the main x-axis columns. Use \code{FALSE}
for no grouping. Default \code{NULL} looks clustering result but will not
group if no clustering is found.}

\item{colorBy}{The name of another categorical variable in \code{cellMeta}
slot. This split the main grouping columns and color the violins. Default
\code{NULL} will not split and color the violins.}

\item{box}{Logical, whether to add boxplot. Default \code{FALSE}.}

\item{boxAlpha}{Numeric, transparency of boxplot. Default \code{0.1}.}

\item{yFunc}{Function to transform the y-axis. Default is
\code{log1p(x*1e4)}. Set to \code{NULL} for no transformation.}

\item{showLegend}{Whether to show the legend. Default \code{FALSE}.}

\item{xlabAngle}{Numeric, counter-clockwise rotation angle in degrees of X
axis label text. Default \code{40}.}

\item{...}{
  Arguments passed on to \code{\link[=.ggplotLigerTheme]{.ggplotLigerTheme}}
  \describe{
    \item{\code{title,subtitle,xlab,ylab}}{Main title, subtitle or X/Y axis title text.
By default, no main title or subtitle will be set, and X/Y axis title will be
the names of variables used for plotting. Use \code{NULL} to hide elements.
\code{TRUE} for \code{xlab} or \code{ylab} shows default values.}
    \item{\code{legendFillTitle}}{Legend title text for fill aesthetics, often used for
violin, box, bar plots. Default \code{NULL} shows the original variable name.}
    \item{\code{legendPosition}}{Text indicating where to place the legend. Choose from
\code{"top"}, \code{"bottom"}, \code{"left"} or \code{"right"}. Default
\code{"right"}.}
    \item{\code{baseSize}}{One-parameter control of all text sizes. Individual text
element sizes can be controlled by other size arguments. "Title" sizes are
2 points larger than "text" sizes when being controlled by this.}
    \item{\code{titleSize,xTitleSize,yTitleSize,legendTitleSize}}{Size of main title,
axis titles and legend title. Default \code{NULL} controls by
\code{baseSize + 2}.}
    \item{\code{subtitleSize,xTextSize,yTextSize,legendTextSize}}{Size of subtitle text,
axis texts and legend text. Default \code{NULL} controls by \code{baseSize}.}
    \item{\code{yFacetSize}}{Size of facet strip label text on y-axis. Default
\code{NULL} controls by \code{baseSize - 2}.}
    \item{\code{panelBorder}}{Whether to show rectangle border of the panel instead of
using ggplot classic bottom and left axis lines. Default \code{FALSE}.}
    \item{\code{colorLabels}}{Character vector for modifying category names in a
color legend. Passed to \code{ggplot2::scale_color_manual(labels)}. Default
\code{NULL} uses original levels of the factor.}
    \item{\code{colorValues}}{Character vector of colors for modifying category colors
in a color legend. Passed to \code{ggplot2::scale_color_manual(values)}.
Default \code{NULL} uses internal selected palette when <= 26 categories are
presented, otherwise ggplot hues.}
    \item{\code{legendNRow,legendNCol}}{Integer, when too many categories in one
variable, arranges number of rows or columns. Default \code{NULL},
automatically split to \code{ceiling(levels(variable)/15)} columns.}
    \item{\code{plotly}}{Whether to use plotly to enable web based interactive browsing
for the plot. Requires installation of package "plotly". Default
\code{FALSE}.}
  }}
}
\value{
A ggplot object.
}
\description{
Make violin plots for each given gene grouped by cluster variable and stack
along y axis.
}
\details{
If \code{xlab} need to be set, set \code{xlabAngle} at the same time. This is
due to that the argument parsing mechanism will partially match it to main
function arguments before matching the \code{...} arguments.
}
\examples{
plotClusterGeneViolin(pbmcPlot, varFeatures(pbmcPlot)[1:10])
}
