% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotProportionBox}
\alias{plotProportionBox}
\title{Box plot of cluster proportion in each dataset, grouped by condition}
\usage{
plotProportionBox(
  object,
  useCluster = NULL,
  conditionBy = NULL,
  sampleBy = "dataset",
  splitByCluster = FALSE,
  dot = FALSE,
  dotSize = getOption("ligerDotSize", 1),
  dotJitter = FALSE,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} object.}

\item{useCluster}{Name of variable in \code{cellMeta(object)}. Default
\code{NULL} uses default cluster.}

\item{conditionBy}{Name of the variable in \code{cellMeta(object)} that
represents the condition. Must be a high level variable of the
\code{sampleBy} variable, i.e. each sample must belong to only one condition.
Default \code{NULL} does not group samples by condition.}

\item{sampleBy}{Name of the variable in \code{cellMeta(object)} that
represents individual samples. Default \code{"dataset"}.}

\item{splitByCluster}{Logical, whether to split the wide grouped box plot by
cluster, into a list of boxplots for each cluster. Default \code{FALSE}.}

\item{dot}{Logical, whether to add dot plot on top of the box plot. Default
\code{FALSE}.}

\item{dotSize}{Size of the dot. Default uses user option "ligerDotSize", or
\code{1} if not set.}

\item{dotJitter}{Logical, whether to jitter the dot to avoid overlapping
within a box when many dots are presented. Default \code{FALSE}.}

\item{...}{
  Arguments passed on to \code{\link[=.ggplotLigerTheme]{.ggplotLigerTheme}}
  \describe{
    \item{\code{title,subtitle,xlab,ylab}}{Main title, subtitle or X/Y axis title text.
By default, no main title or subtitle will be set, and X/Y axis title will be
the names of variables used for plotting. Use \code{NULL} to hide elements.
\code{TRUE} for \code{xlab} or \code{ylab} shows default values.}
    \item{\code{legendFillTitle}}{Legend title text for fill aesthetics, often used for
violin, box, bar plots. Default \code{NULL} shows the original variable name.}
    \item{\code{showLegend}}{Whether to show the legend. Default \code{TRUE}.}
    \item{\code{legendPosition}}{Text indicating where to place the legend. Choose from
\code{"top"}, \code{"bottom"}, \code{"left"} or \code{"right"}. Default
\code{"right"}.}
    \item{\code{baseSize}}{One-parameter control of all text sizes. Individual text
element sizes can be controlled by other size arguments. "Title" sizes are
2 points larger than "text" sizes when being controlled by this.}
    \item{\code{titleSize,xTitleSize,yTitleSize,legendTitleSize}}{Size of main title,
axis titles and legend title. Default \code{NULL} controls by
\code{baseSize + 2}.}
    \item{\code{subtitleSize,xTextSize,yTextSize,legendTextSize}}{Size of subtitle text,
axis texts and legend text. Default \code{NULL} controls by \code{baseSize}.}
    \item{\code{panelBorder}}{Whether to show rectangle border of the panel instead of
using ggplot classic bottom and left axis lines. Default \code{FALSE}.}
    \item{\code{colorLabels}}{Character vector for modifying category names in a
color legend. Passed to \code{ggplot2::scale_color_manual(labels)}. Default
\code{NULL} uses original levels of the factor.}
    \item{\code{colorValues}}{Character vector of colors for modifying category colors
in a color legend. Passed to \code{ggplot2::scale_color_manual(values)}.
Default \code{NULL} uses internal selected palette when <= 26 categories are
presented, otherwise ggplot hues.}
    \item{\code{legendNRow,legendNCol}}{Integer, when too many categories in one
variable, arranges number of rows or columns. Default \code{NULL},
automatically split to \code{ceiling(levels(variable)/15)} columns.}
    \item{\code{colorPalette}}{For continuous coloring, an index or a palette name to
select from available options from ggplot
\code{\link[ggplot2]{scale_brewer}} or \code{\link[viridisLite]{viridis}}.
Default \code{"magma"}.}
    \item{\code{colorDirection}}{Choose \code{1} or \code{-1}. Applied when
\code{colorPalette} is from Viridis options. Default \code{-1} use darker
color for higher value, while \code{1} reverses this direction.}
    \item{\code{colorLow,colorMid,colorHigh,colorMidPoint}}{All four of these must be
specified to customize palette with}
    \item{\code{naColor}}{The color code for \code{NA} values. Default \code{"#DEDEDE"}.
\code{\link[ggplot2]{scale_colour_gradient2}}. Default \code{NULL}.}
    \item{\code{plotly}}{Whether to use plotly to enable web based interactive browsing
for the plot. Requires installation of package "plotly". Default
\code{FALSE}.}
  }}
}
\value{
A ggplot object or a list of ggplot objects if
\code{splitByCluster = TRUE}.
}
\description{
This function calculate the proportion of each category (e.g. cluster, cell
type) within each dataset, and then make box plot grouped by condition. The
proportion of all categories within one dataset sums up to 1. The condition
variable must be a variable of dataset, i.e. each dataset must belong to only
one condition.
}
\examples{
# "boxes" are expected to appear as horizontal lines, because there's no
# "condition" variable that groups the datasets in the example object, and
# thus only one value exists for each "box".
plotProportionBox(pbmcPlot, conditionBy = "dataset")
}
