% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rma.exact.R
\name{rma.exact.fast}
\alias{rma.exact.fast}
\title{Compute a confidence interval for the grand mean at a user-specified confidence level.}
\usage{
rma.exact.fast(yi, vi, c0 = 1.2 * (length(yi) < 6) + 0.6 * (length(yi) >= 6 &
  length(yi) < 10) + 0.2 * (length(yi) >= 10), level = 0.05, plot = TRUE,
  tau2.bounds = NULL, resolution = 100, Z = NULL, B = 3000,
  tau2.alpha = 0.995)
}
\arguments{
\item{yi}{vector of measurements from the primary studies}

\item{vi}{vector of the variances of the measurements in yi}

\item{c0}{vector of the mixing parameters for the test statistics}

\item{level}{the level of the confidence interval}

\item{plot}{indicator whether to plot the contour of the confidence region}

\item{tau2.bounds}{upper and lower bounds for the range of population variance values for constructing the confidence region; if NULL, value will be calculated from tau2.alpha}

\item{resolution}{resolution of the population variance values for constructing the confidence region}

\item{Z}{a matrix of length(yi) rows with each row consisting of standard normal samples to be used in the monte carlo estimation of the null distribution of the test statistic; if NULL, B values
will be sampled per row}

\item{B}{the number of monte carlo replicates per primary study observation to be used}

\item{tau2.alpha}{the level of the exact CI with which to bounds on population variance when constructing the confidence region}
}
\value{
a matrix with length(c0) rows and each row containing the lower and upper endpoints of the confidence interval for the given mixing parameter
}
\description{
Compute a confidence interval for the grand mean at a user-specified confidence level.
}
\examples{

K <- 5
c0 <- 1
mu0 <- 0
tau2 <- 12.5
vi <- (seq(1, 5, length=K))^2
yi=rnorm(K)*sqrt(vi+tau2)+mu0
rma.exact.fast(yi=yi,vi=vi,level=.05)
}
\seealso{
\code{\link{rma.exact}} for computing entire confidence regions
}
