% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/nsga.R, R/nsga2.R, R/nsga3.R
\docType{methods}
\name{summary}
\alias{summary}
\alias{summary,nsga-method}
\alias{summary,nsga,nsga-method}
\alias{summary,nsga1-method}
\alias{summary,nsga2-method}
\alias{summary,nsga3-method}
\title{Methods for Function 'summary' in Package 'rmoo'}
\usage{
summary(object, ...)

\S4method{summary}{nsga}(object, ...)

\S4method{summary}{nsga1}(object, ...)

\S4method{summary}{nsga2}(object, ...)

\S4method{summary}{nsga3}(object, ...)
}
\arguments{
\item{object}{Objects of either class \linkS4class{nsga1},
\linkS4class{nsga2},  or \linkS4class{nsga3}.}

\item{...}{other arguments passed on to methods. Passing \code{"reference_dirs"}
as arguments will evaluate the performance metrics Hypervolumen,
Generational Distance, and Inverse Generational Distance.}
}
\value{
A summary of the values resulting from the execution of an algorithm.
}
\description{
Method used to summarize the results of the evaluations, passing additional
arguments in the summary method the performance metrics is evaluated.
}
\examples{
# Where 'out' is an object of class nsga1, nsga2, or nsga3
#
# summary(out)
#
# For the evaluation of the metrics, pass the reference point
#
# ref_points <- generate_reference_points(3,12)
# summary(out, reference_dirs = ref_points)

}
\author{
Francisco Benitez
\email{benitezfj94@gmail.com}
}
