% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kld.inconsistency_function.R
\name{kld_inconsistency}
\alias{kld_inconsistency}
\title{Density plots of local inconsistency results and Kullback-Leibler divergence
 when 'rnmamod', 'netmeta' or 'gemtc' R packages are used}
\usage{
kld_inconsistency(
  node,
  threshold = 1e-05,
  drug_names = NULL,
  outcome = NULL,
  scales = "free",
  show_incons = TRUE,
  y_axis_name = TRUE,
  title_name = NULL,
  axis_title_size = 13,
  axis_text_size = 13,
  text_size = 3.5,
  strip_text_size = 13,
  legend_title_size = 13,
  legend_text_size = 13,
  str_wrap_width = 10
)
}
\arguments{
\item{node}{An object of S3 class \code{\link{run_nodesplit}} or class
\code{\link[gemtc:mtc.nodesplit]{mtc.nodesplit}}
(see \href{https://CRAN.R-project.org/package=gemtc}{gemtc}) or
class \code{\link[netmeta:netsplit]{netsplit}} (see
\href{https://CRAN.R-project.org/package=netmeta}{netmeta}).}

\item{threshold}{A positive number indicating the threshold of not concerning
inconsistency, that is, the minimally allowed deviation between the direct
and indirect estimates for a split node that does raise concerns for
material inconsistency. The argument is optional.}

\item{drug_names}{A vector of labels with the name of the interventions in
the order they appear in the argument \code{data}. It is not relevant for
\href{https://CRAN.R-project.org/package=gemtc}{gemtc} and
\href{https://CRAN.R-project.org/package=netmeta}{netmeta}.}

\item{outcome}{Optional argument to describe the effect measure used (the
x-axis of the plots).}

\item{scales}{A character on whether both axes should be fixed
(\code{"fixed"}) or free (\code{"free"}) or only one of them be free
(\code{"free_x"} or \code{"free_y"}). \code{scales} determines the scales
argument found in function (\code{\link[ggplot2:facet_wrap]{facet_wrap}})
in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}. The default is
(\code{"free"}).}

\item{show_incons}{Logical to indicate whether to present the point estimate
and 95% interval of the inconsistency parameter. The default is \code{TRUE}
(report).}

\item{y_axis_name}{Logical to indicate whether to present the title of y-axis
('Density'). The default is \code{TRUE} (report).}

\item{title_name}{Text for the title of the plot. \code{title_name}
determines the labs argument of the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.}

\item{axis_title_size}{A positive integer for the font size of axis title.
\code{axis_title_size} determines the axis.title argument found in the
theme's properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.
The default option is 13.}

\item{axis_text_size}{A positive integer for the font size of axis text.
\code{axis_text_size} determines the axis.text argument found in the
theme's properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.
The default option is 13.}

\item{text_size}{A positive integer for the font size of labels.
\code{text_size} determines the size argument found in the geom_text
function in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.
The default option is 3.5.}

\item{strip_text_size}{A positive integer for the font size of facet labels.
\code{legend_text_size} determines the legend.text argument found in
the theme's properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.
The default option is 13.}

\item{legend_title_size}{A positive integer for the font size of legend
title. \code{legend_text_size} determines the legend.text argument found in
the theme's properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.
The default option is 13.}

\item{legend_text_size}{A positive integer for the font size of legend text.
\code{legend_text_size} determines the legend.text argument found in the
theme's properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.
The default option is 13.}

\item{str_wrap_width}{A positive integer for wrapping the axis labels in the
percent stacked bar-plot. \code{str_wrap_width} determines the
\code{\link[stringr:str_wrap]{str_wrap}} function of the R-package
\href{https://CRAN.R-project.org/package=stringr}{stringr}.}
}
\value{
The first plot is a panel of density plots for each split node sorted
in ascending order of the Kullback-Leibler divergence value. Blue and black
lines refer to the direct and indirect estimates, respectively. The grey
segment refers to the 95\% credible (confidence) interval of the
inconsistency parameter, when \code{\link{run_nodesplit}}
(\code{\link[netmeta:netsplit]{netsplit}}) has been applied, with a darker
grey line referring to the point estimate.
When \code{\link[gemtc:mtc.nodesplit]{mtc.nodesplit}} has been employed, the
95\% confidence interval has been approximated using the Bucher's approach
based on the corresponding direct and indirect results. This was necessary
because \code{\link[gemtc:mtc.nodesplit]{mtc.nodesplit}} (version 1.0-2)
returns only the inconsistency p-values rather than the posterior results on
the inconsistency parameters. The mean estimate on
the scale of the selected effect measure appears at the top of each density
curve.

The Kullback-Leibler divergence value appears at the top left of each plot
in three colours: black, if no threshold has been defined (the default),
green, if the Kullback-Leibler divergence is below the specified
\code{threshold} (not concerning inconsistency) and red, if the
Kullback-Leibler divergence is at least the specified \code{threshold}
(substantial inconsistency).

The second plot is a percent stacked bar plot on the percentage contribution
of approximating direct with indirect estimate (and vice-versa) to the total
information loss for each target comparison. Total information loss is
defined as the sum of the KLD value when approximating the direct with
indirect estimate (blue bars), and the KLD when approximating the indirect
with direct estimate (black bars). Values parentheses refer to the
corresponding KLD value.

The function also returns the data-frame \code{average_KLD} that includes the
split comparisons and the corresponding average Kullback-Leibler divergence
value.
}
\description{
A panel of density plots on the direct and indirect estimates of the
selected comparisons based on approach for local inconsistency evaluation,
such as back-calculation and node-splitting approaches (Dias et al., 2010;
van Valkenhoef et al., 2016) and loop-specific approach (Bucher et al., 1997)
accompanied by the average Kullback-Leibler divergence. Additionally, stacked
bar plots on the percentage contribution of either Kullback-Leibler
divergence (from direct to indirect, and vice-versa) to the total information
loss for each selected comparison are presented.
The function handles results also from the R-packages
  \href{https://CRAN.R-project.org/package=gemtc}{gemtc} and
  \href{https://CRAN.R-project.org/package=netmeta}{netmeta}.
}
\examples{

\dontrun{
data("nma.baker2009")

# Read results from 'run_nodesplit' (using the default arguments)
node <- readRDS(system.file('extdata/node_baker.rds', package = 'rnmamod'))

# The names of the interventions in the order they appear in the dataset
interv_names <- c("placebo", "budesonide", "budesonide plus formoterol",
                  "fluticasone", "fluticasone plus salmeterol",
                  "formoterol", "salmeterol", "tiotropium")

# Apply the function
kld_inconsistency(node = node,
                  threshold = 0.64,
                  drug_names = interv_names,
                  outcome = "Odds ratio (logarithmic scale)",
                  str_wrap_width = 15)
}

}
\references{
Bucher HC, Guyatt GH, Griffith LE, Walter SD. The results of direct and
indirect treatment comparisons in meta-analysis of randomized controlled
trials. \emph{J Clin Epidemiol} 1997;\bold{50}(6):683--91.

Dias S, Welton NJ, Caldwell DM, Ades AE. Checking consistency in mixed
treatment comparison meta-analysis.
\emph{Stat Med} 2010;\bold{29}(7-8):932--44.
doi: 10.1002/sim.3767

Kullback S, Leibler RA. On information and sufficiency.
\emph{Ann Math Stat} 1951;\bold{22}(1):79--86. doi: 10.1214/aoms/1177729694

van Valkenhoef G, Dias S, Ades AE, Welton NJ. Automated generation of
node-splitting models for assessment of inconsistency in network
meta-analysis. \emph{Res Synth Methods} 2016;\bold{7}(1):80--93.
doi: 10.1002/jrsm.1167
}
\seealso{
\code{\link[ggplot2:facet_wrap]{facet_wrap}},
  \code{\link[gemtc:mtc.nodesplit]{mtc.nodesplit}},
  \code{\link{kld_measure}},
  \code{\link[netmeta:netsplit]{netsplit}},
  \code{\link{run_nodesplit}},
  \code{\link[stringr:str_wrap]{str_wrap}}
}
\author{
{Loukia M. Spineli}
}
