% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.robpolycor}
\alias{plot.robpolycor}
\title{Plot method for classes \code{"robpolycor"} and \code{"polycor"}.}
\usage{
\method{plot}{robpolycor}(x, cutoff = 3, ...)
}
\arguments{
\item{x}{Object of class \code{"robpolycor"} or \code{"polycor"}.}

\item{cutoff}{Cutoff beyond which the color scale for Pearson residuals is truncated.}

\item{...}{Additional parameters to be passed down.}
}
\value{
An object of class \code{"\link[ggplot2]{ggplot}"}.
}
\description{
Plot method for classes \code{"robpolycor"} and \code{"polycor"}.
}
\examples{
## example data
set.seed(123)
x <- sample(c(1,2,3), size = 100, replace = TRUE)
y <- sample(c(1,2,3), size = 100, replace = TRUE)

fit <- polycor(x,y) 
plot(fit)

}
