test_that("zero-argument exports are callable (for existing symbols)", {
  skip_if_not(requireNamespace("robustfa", quietly = TRUE))
  ns <- asNamespace("robustfa")
  ex <- getNamespaceExports("robustfa")
  exists_in_ns <- vapply(ex, exists, logical(1), envir = ns, inherits = FALSE)
  missing <- ex[!exists_in_ns]
  if (length(missing)) message("Exports listed but not found in namespace: ", paste(missing, collapse = ", "))
  present <- ex[exists_in_ns]
  for (fn in present) {
    obj <- get(fn, envir = ns, inherits = FALSE)
    if (is.function(obj)) {
      fmls <- formals(args(obj))
      required <- names(fmls)[vapply(fmls, is.symbol, logical(1))]
      if (length(required) == 0) {
        expect_error(do.call(obj, list()), NA, info = paste("call failed for", fn))
      }
    }
  }
})
