% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.roclearn.R
\name{predict.roclearn}
\alias{predict.roclearn}
\title{Predictions from a fitted linear model}
\usage{
\method{predict}{roclearn}(object, newdata, type = c("class", "response"), ...)
}
\arguments{
\item{object}{A fitted model object of class \code{"roclearn"} (linear).}

\item{newdata}{A data frame or matrix of predictors for which predictions
are desired. Categorical variables are automatically dummy-encoded and
aligned to the training structure.}

\item{type}{Prediction type: \code{"class"} for \{-1, 1\} labels, or
\code{"response"} for raw decision scores.}

\item{...}{Not used.}
}
\value{
A numeric vector of predictions (\{-1, 1\}) if \code{type = "class"},
or raw decision scores if \code{type = "response"}.
}
\description{
Generate predictions from a fitted linear model.
}
\examples{
set.seed(123)
n <- 100
n_pos <- round(0.2 * n)
n_neg <- n - n_pos
X <- rbind(
  matrix(rnorm(2 * n_neg, mean = -1), ncol = 2),
  matrix(rnorm(2 * n_pos, mean =  1), ncol = 2)
)
y <- c(rep(-1, n_neg), rep(1, n_pos))

fit <- roclearn(X, y, lambda = 0.1, approx=TRUE)

# Predict classes {-1, 1}
predict(fit, X, type = "class")

# Predict decision scores
predict(fit, X, type = "response")
}
\seealso{
\code{\link{roclearn}}, \code{\link{cv.roclearn}}
}
