% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rope.R
\name{ropegraph}
\alias{ropegraph}
\title{Convenience wrapper for \code{rope} for adjacency matrices}
\usage{
ropegraph(data, B, ...)
}
\arguments{
\item{data}{List of symmetric matrices, one matrix for each penalization
level}

\item{B}{Number of bootstraps used to construct \code{data}. At least 21 are
needed for u-shape test heuristic to work, but in general it is recommended
to use many more.}

\item{...}{Additional arguments are passed on to \code{rope}.}
}
\value{
A list with components
  \item{selection}{list of symmetric matrices, one matrix for each fdr
    target}
  \item{q}{symmetric matrix of q-values}
  \item{level}{index of most separating parameter value}
  \item{alt.prop}{estimated proportion of alternative variables}
}
\description{
When modeling graphs it may be more convenient to store data as matrices
instead of row vectors.
}
\examples{
\dontrun{
data # a list of symmetric matrices, one matrix for each penalization level,
  # each matrix containing selection counts for each edge over 100 bootstraps
fdr <- c(0.05, 0.1)
result <- rope(data, 100, fdr)
}

}
