% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_checks.R
\name{type_checks}
\alias{type_checks}
\alias{is.scalar}
\alias{is.scalar_or_null}
\alias{is.numeric_or_null}
\alias{is.character_or_null}
\alias{is.logical_or_null}
\alias{is.df_or_null}
\alias{is.list_or_null}
\alias{is.atomic_nan}
\alias{is.irregular_list}
\alias{is.bad_for_calcs}
\alias{any_bad_for_calcs}
\alias{all_good_for_calcs}
\alias{is.bad_for_indexing}
\alias{is.good_for_indexing}
\alias{is.bad_and_equal}
\alias{is.good_for_calcs}
\alias{is.null_or_na}
\title{Type Checks}
\usage{
is.scalar(x)

is.scalar_or_null(x)

is.numeric_or_null(x)

is.character_or_null(x)

is.logical_or_null(x)

is.df_or_null(x)

is.list_or_null(x)

is.atomic_nan(x)

is.irregular_list(x)

is.bad_for_calcs(x, na.rm = FALSE)

any_bad_for_calcs(x, ..., na.rm = FALSE)

all_good_for_calcs(x, ..., na.rm = FALSE)

is.bad_for_indexing(x)

is.good_for_indexing(x)

is.bad_and_equal(x, y)

is.bad_for_calcs(x, na.rm = FALSE)

is.good_for_calcs(x, na.rm = FALSE)

is.null_or_na(x)
}
\arguments{
\item{x}{object to be tested}

\item{na.rm}{If true, NA values aren't considered bad for calculations}

\item{...}{Values to be testes}

\item{y}{object to be tested}
}
\value{
a logical value
}
\description{
Misc/useful type checks to prevent duplicated code
}
\author{
Steven Nydick, \email{steven.nydick@kornferry.com}
}
