% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/butterfly_call.R
\name{butterfly.call}
\alias{butterfly.call}
\title{Butterfly Call Spread Strategy Function}
\usage{
butterfly.call(
  k1,
  k2,
  k3,
  c1,
  c2,
  c3,
  spread = c("long", "short"),
  llimit = 20,
  ulimit = 20
)
}
\arguments{
\item{k1}{Excercise Price of 1st Long call Option (Long Spread)/ Excercise Price of 1st Short call Option (Short Spread)}

\item{k2}{Excercise Price of Short call Option (Long Spread) / Excercise Price of Long call Option (Short Spread)}

\item{k3}{Excercise Price of 2nd Long call Option (Long Spread) / Excercise Price of 2nd Short call Option (Short Spread)}

\item{c1}{Premium of 1st Long call Option (Long Spread)/ Premium of 1st Short call Option (Short Spread)}

\item{c2}{Premium of Short call Option (Long Spread) / Premium of Long call Option (Short Spread)}

\item{c3}{Premium of 2nd Long call Option (Long Spread) / Premium of 2nd Short call Option (Short Spread)}

\item{spread}{Type of Spread, Default: c("long", "short")}

\item{llimit}{Lower limit of stock price at Expiration., Default: 20}

\item{ulimit}{Upper Limit of Stock Price at Expiration, Default: 20}
}
\value{
OUTPUT_DESCRIPTION Returns the profit/loss generated from the strategy along with the profit/loss of individual contract and an interactive graph for the same.
}
\description{
This function can be used to develop a Butterfly call Spread Strategy.
}
\details{
The long butterfly call spread is created by buying one in-the-money call option with a low strike price, writing two at-the-money call options, and buying one out-of-the-money call option with a higher strike price. The short butterfly spread is created by selling one in-the-money call option with a lower strike price, buying two at-the-money call options, and selling an out-of-the-money call option at a higher strike price.
}
\examples{
butterfly.call(100, 95, 105, 2.3, 1.25, 3.2, spread = 'long')
}
