% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reround.R
\name{reround}
\alias{reround}
\title{General interface to reconstructing rounded numbers}
\usage{
reround(
  x,
  digits = 0L,
  rounding = "up_or_down",
  threshold = 5,
  symmetric = FALSE
)
}
\arguments{
\item{x}{Numeric. Vector of possibly original values.}

\item{digits}{Integer. Number of decimal places in the reported key values
(i.e., mean or percentage within \code{\link[scrutiny:grim]{scrutiny::grim()}}, or standard deviation within
\code{\link[scrutiny:grimmer]{scrutiny::grimmer()}}).}

\item{rounding}{String. The rounding method that is supposed to have been
used originally. See \code{vignette("rounding-options")}. Default is
\code{"up_or_down"}, which returns two values: \code{x} rounded up \emph{and} down.}

\item{threshold}{Integer. If \code{rounding} is set to \code{"up_from"}, \code{"down_from"},
or \code{"up_from_or_down_from"}, \code{threshold} must be set to the number from
which the reconstructed values should then be rounded up or down. Otherwise
irrelevant. Default is \code{5}.}

\item{symmetric}{Logical. Set \code{symmetric} to \code{TRUE} if the rounding of
negative numbers with \code{"up_or_down"}, \code{"up"}, \code{"down"},
\code{"up_from_or_down_from"}, \code{"up_from"}, or \code{"down_from"} should mirror that
of positive numbers so that their absolute values are always equal.
Otherwise irrelevant. Default is \code{FALSE}.}
}
\value{
Numeric vector of length 1 or 2. (It has length 1 unless \code{rounding}
is \code{"up_or_down"}, \code{"up_from_or_down_from"}, or\code{"ceiling_or_floor"}, in
which case it has length 2.)
}
\description{
\code{reround()} takes one or more intermediate reconstructed values
and rounds them in some specific way -- namely, the way they are supposed
to have been rounded originally, in the process that generated the reported
values.

This function provides an interface to all of scrutiny's rounding functions
as well as \code{\link[base:Round]{base::round()}}. It is used as a helper within
\code{\link[scrutiny:grim]{scrutiny::grim()}}, \code{\link[scrutiny:grimmer]{scrutiny::grimmer()}}, and \code{\link[scrutiny:debit]{scrutiny::debit()}};
and it might find use in other places for consistency testing or
reconstruction of statistical analyses.
}
\details{
\code{reround()} internally calls the appropriate rounding function(s)
determined by the \code{rounding} argument. See \code{vignette("rounding-options")}
for a complete list of values that \code{rounding} can take.

For the specific rounding functions themselves, see documentation at
\code{\link[=round_up]{round_up()}}, \code{\link[=round_ceiling]{round_ceiling()}}, and \code{\link[base:Round]{base::round()}}.
}
\examples{
# You can specify the rounding procedure:
reround(4.1679, digits = 2, rounding = "up")

# Default is roundding both up and down:
reround(4.1679, digits = 2)
}
