% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pctpred_GLIdiff.R
\name{pctpred_GLIdiff}
\alias{pctpred_GLIdiff}
\title{Convert diffusing capacity values to \% predicted using GLI (2017) equations}
\usage{
pctpred_GLIdiff(
  age,
  height,
  gender = 1,
  TLCO = NULL,
  KCO = NULL,
  VA = NULL,
  SI = TRUE
)
}
\arguments{
\item{age}{Age in years}

\item{height}{Height in meters}

\item{gender}{Gender (1 = male, 2 = female) or a factor with two levels (first = male). Default is 1.}

\item{TLCO}{Transfer factor of the lung for carbon monoxide (in mmol/min/kPa if
\code{SI=TRUE} or ml/min/mmHg if \code{SI=FALSE})}

\item{KCO}{Transfer coefficient of the lung for carbon monoxide (in mmol/min/kPa/lt if
\code{SI=TRUE} or ml/min/mmHg/lt if \code{SI=FALSE})}

\item{VA}{Alveolar volume (in lt)}

\item{SI}{(default TRUE) Use SI (mmol/min/kPa) or traditional (ml/min/mmHg) units?}
}
\value{
If only one diffusing capacity argument is supplied, the function
returns a numeric vector. If more are supplied, the function returns 
a data.frame with the same number of columns.
}
\description{
This function takes absolute diffusing capacity measurements (TLCO, KCO and VA)
plus demographic data (age, height, gender) and converts
them to percent (\%) predicted based on the GLI (2017) equations.
}
\details{
At least one of the diffusing capacity measurement arguments must be set (i.e. be
non-\code{NULL}). Arguments \code{age}, \code{height} and \code{gender} 
must be vectors of length equal to the length of the
diffusing capacity measurement vector(s), or of length one, in which case their
value is recycled. If any input vector is not of equal length, the function
stops with an error.
}
\examples{
# Random data, 4 patients, one parameter supplied (TLCO)
pctpred_GLIdiff(age=seq(25,40,5), height=c(1.8, 1.9, 1.75, 1.85),
      gender=c(2,1,2,1), TLCO=c(7.8, 8.8, 7.5, 8.5))

}
