% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pctpred_GLIgl.R
\name{pctpred_GLIgl}
\alias{pctpred_GLIgl}
\title{Convert spirometric values to \% predicted using GLI global (2022) equations}
\usage{
pctpred_GLIgl(age, height, gender = 1, FEV1 = NULL, FVC = NULL, FEV1FVC = NULL)
}
\arguments{
\item{age}{Age in years}

\item{height}{Height in meters}

\item{gender}{Gender (1 = male, 2 = female) or a factor with two levels (first = male). Default is 1.}

\item{FEV1}{Forced Expiratory Volume in 1 second (lt)}

\item{FVC}{Forced Vital Capacity (lt)}

\item{FEV1FVC}{FEV1 / FVC ratio}
}
\value{
If only one spirometry argument is supplied, the function
returns a numeric vector. If more are supplied, the function returns 
a data.frame with the same number of columns.
}
\description{
This function takes absolute spirometry measurements (FEV1, FVC or FEV1FVC)
in lt plus demographic data (age, height, gender) and converts
them to percent (\%) predicted based on the GLI global (2022) equations.
}
\details{
At least one of the spirometric measurement arguments must be set (i.e. be
non-\code{NULL}). Arguments \code{age}, \code{height} and \code{gender} 
must be vectors of length equal to the length of the
spirometric measurement vector(s), or of length one, in which case their
value is recycled. If any input vector is not of equal length, the function
stops with an error.
}
\examples{
# Random data, 4 patients, one parameter supplied (FEV1)
pctpred_GLIgl(age=seq(25,40,5), height=c(1.8, 1.9, 1.75, 1.85),
      gender=c(2,1,2,1), FEV1=c(3.5, 4, 3.6, 3.9))

}
