% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete.R
\name{delete}
\alias{delete}
\alias{delete,SsimObject-method}
\title{Delete Project, Scenario, Folder, Chart or Datasheet}
\usage{
delete(
  ssimObject,
  project = NULL,
  scenario = NULL,
  folder = NULL,
  chart = NULL,
  datasheet = NULL,
  force = FALSE,
  session = NULL
)

\S4method{delete}{SsimObject}(
  ssimObject,
  project = NULL,
  scenario = NULL,
  folder = NULL,
  chart = NULL,
  datasheet = NULL,
  force = FALSE,
  session = NULL
)
}
\arguments{
\item{ssimObject}{\code{\link{SsimLibrary-class}}, \code{\link{Project-class}},
\code{\link{Scenario-class}}, \code{\link{Folder-class}}, or \code{\link{Chart-class}}
object}

\item{project}{character string, numeric, or vector of these. One or more
\code{\link{Project-class}} names or ids. Note that project argument is ignored
if ssimObject is a list. Note that integer ids are slightly faster (optional)}

\item{scenario}{character string, numeric, or vector of these. One or more
\code{\link{Scenario-class}} names or ids. Note that scenario argument is
ignored if ssimObject is a list. Note that integer ids are slightly faster
(optional)}

\item{folder}{character string, numeric, or vector of these. One or more
\code{\link{Folder-class}} names or ids. Note that folder argument is
ignored if ssimObject is a list. Note that integer ids are slightly faster
(optional)}

\item{chart}{character string, numeric, or vector of these. One or more
\code{\link{Chart-class}} names or ids. Note that chart argument is
ignored if SsimObject is a list. Note that integer ids are slightly faster
(optional)}

\item{datasheet}{character string or vector of these. One or more datasheet
names (optional)}

\item{force}{logical. If \code{FALSE} (default), user will be prompted to approve
removal of each item}

\item{session}{\code{\link{Session-class}} object. If \code{NULL} (default), session()
will be used. Only applicable when \code{ssimObject} argument is a character}
}
\value{
Invisibly returns a list of boolean values corresponding to each
input: \code{TRUE} upon success (i.e.successful deletion) and \code{FALSE} upon failure.
}
\description{
Delete Project, Scenario, Folder, Chart or Datasheet
}
\details{
Deletes one or more items. Note that this is irreversible. To delete
a library, you must use the \code{\link{deleteLibrary}} function instead.
}
\examples{
\dontrun{
# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set up a SyncroSim Session, SsimLibrary, and Project
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)
myProject <- project(myLibrary, project = "a project")

# Check the Projects associated with this SsimLibrary
project(myLibrary)

# Delete Project
delete(myLibrary, project = "a project", force = TRUE)

# Check that Project was successfully deleted from SsimLibrary
project(myLibrary)
}

}
