% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00tabletrees.R
\name{AnalyzeVarSplit}
\alias{AnalyzeVarSplit}
\alias{AnalyzeColVarSplit}
\alias{AnalyzeMultiVars}
\title{Define a subset tabulation/analysis}
\usage{
AnalyzeVarSplit(
  var,
  split_label = var,
  afun,
  defrowlab = "",
  cfun = NULL,
  cformat = NULL,
  split_format = NULL,
  split_na_str = NA_character_,
  inclNAs = FALSE,
  split_name = var,
  extra_args = list(),
  indent_mod = 0L,
  label_pos = "default",
  cvar = "",
  section_div = NA_character_,
  formats_var = NULL,
  na_strs_var = NULL
)

AnalyzeColVarSplit(
  afun,
  defrowlab = "",
  cfun = NULL,
  cformat = NULL,
  split_format = NULL,
  split_na_str = NA_character_,
  inclNAs = FALSE,
  split_name = "",
  extra_args = list(),
  indent_mod = 0L,
  label_pos = "default",
  cvar = "",
  section_div = NA_character_
)

AnalyzeMultiVars(
  var,
  split_label = "",
  afun,
  defrowlab = "",
  cfun = NULL,
  cformat = NULL,
  split_format = NULL,
  split_na_str = NA_character_,
  inclNAs = FALSE,
  .payload = NULL,
  split_name = NULL,
  extra_args = list(),
  indent_mod = 0L,
  child_labels = c("default", "topleft", "visible", "hidden"),
  child_names = var,
  cvar = "",
  section_div = NA_character_,
  formats_var = NULL,
  na_strs_var = NULL
)
}
\arguments{
\item{var}{(\code{string})\cr variable name.}

\item{split_label}{(\code{string})\cr label to be associated with the table generated by the split. Not to be confused
with labels assigned to each child (which are based on the data and type of split during tabulation).}

\item{afun}{(\code{function})\cr analysis function. Must accept \code{x} or \code{df} as its first parameter. Can optionally take
other parameters which will be populated by the tabulation framework. See Details in \code{\link[=analyze]{analyze()}}.}

\item{defrowlab}{(\code{character})\cr default row labels, if not specified by the return value of \code{afun}.}

\item{cfun}{(\code{list}, \code{function}, or \code{NULL})\cr tabulation function(s) for creating content rows. Must accept \code{x}
or \code{df} as first parameter. Must accept \code{labelstr} as the second argument. Can optionally accept all optional
arguments accepted by analysis functions. See \code{\link[=analyze]{analyze()}}.}

\item{cformat}{(\code{string}, \code{function}, or \code{list})\cr format for content rows.}

\item{split_format}{(\code{string}, \code{function}, or \code{list})\cr default format associated with the split being created.}

\item{split_na_str}{(\code{character})\cr NA string vector for use with \code{split_format}.}

\item{inclNAs}{(\code{logical})\cr whether NA observations in the \code{var} variable(s) should be included when performing
the analysis. Defaults to \code{FALSE}.}

\item{split_name}{(\code{string})\cr name associated with the split (for pathing, etc.).}

\item{extra_args}{(\code{list})\cr extra arguments to be passed to the tabulation function. Element position in the list
corresponds to the children of this split. Named elements in the child-specific lists are ignored if they do
not match a formal argument of the tabulation function.}

\item{indent_mod}{(\code{numeric})\cr modifier for the default indent position for the structure created by this
function (subtable, content table, or row) \emph{and all of that structure's children}. Defaults to 0, which
corresponds to the unmodified default behavior.}

\item{label_pos}{(\code{string})\cr location where the variable label should be displayed. Accepts \code{"hidden"}
(default for non-analyze row splits), \code{"visible"}, \code{"topleft"}, and \code{"default"} (for analyze splits only). For
\code{analyze} calls, \code{"default"} indicates that the variable should be visible if and only if multiple variables are
analyzed at the same level of nesting.}

\item{cvar}{(\code{string})\cr the variable, if any, that the content function should accept. Defaults to \code{NA}.}

\item{section_div}{(\code{string})\cr string which should be repeated as a section divider after each group defined
by this split instruction, or \code{NA_character_} (the default) for no section divider.}

\item{formats_var}{(\code{string} or \code{NULL})\cr \code{NULL} (the default) or the name of the list column containing named
lists of default formats to use. These will be applied with the same precedence as the \code{format} argument; i.e.,
they will not override formats (other than \code{"default"}) set within the afun.
Cannot be used simultaneously with \code{format}.}

\item{na_strs_var}{(\code{string} or \code{NULL})\cr \code{NULL} (the default) or the name of the list column containing named
lists of default NA strings to use. These will be applied with the same precedence as the \code{format} argument; i.e.,
they will not override formats (other than \code{"default"}) set within the afun.
Cannot be used simultaneously with \code{format}. Cannot be used if \code{formats_var} is \code{NULL}.}

\item{.payload}{(\code{list})\cr used internally, not intended to be set by end users.}

\item{child_labels}{(\code{string})\cr the display behavior for the labels (i.e. label rows) of the children of this
split. Accepts \code{"default"}, \code{"visible"}, and \code{"hidden"}. Defaults to \code{"default"} which flags the label row as
visible only if the child has 0 content rows.}

\item{child_names}{(\code{character})\cr names to be given to the subsplits contained by a compound split (typically
an \code{AnalyzeMultiVars} split object).}
}
\value{
An \code{AnalyzeVarSplit} object.

An \code{AnalyzeMultiVars} split object.
}
\description{
Define a subset tabulation/analysis

Define a subset tabulation/analysis
}
\author{
Gabriel Becker
}
