% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{set_formatter_star}
\alias{set_formatter_star}
\title{Set star rating formatter}
\usage{
set_formatter_star(widget, column, number_of_stars = NA, hoz_align = "center")
}
\arguments{
\item{widget}{A \code{\link[=tabulator]{tabulator()}} HTML widget.}

\item{column}{The name of the column the formatter is applied to.}

\item{number_of_stars}{The maximum number of stars to be displayed.
If set to \code{NA}, the maximum value of the column is used.}

\item{hoz_align}{(character): The horizontal alignment of the column.}
}
\value{
The updated \code{\link[=tabulator]{tabulator()}} HTML widget
}
\description{
Set star rating formatter
}
\examples{
data <- data.frame(
  Passengers = c("Hans", "Franz", "Ferdinand", "Julia"),
  PassengerClass = c(1, 2, 1, 3)
)

tabulator(data, width = 200) |>
  set_formatter_star("PassengerClass", number_of_stars = max(data$PassengerClass))
}
