% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download-file.R
\name{download_file}
\alias{download_file}
\title{Download once}
\usage{
download_file(
  url,
  dir = tempdir(),
  fname = url_basename(url),
  overwrite = FALSE,
  mode = "wb",
  timeout = max(300, getOption("timeout")),
  ...
)
}
\arguments{
\item{url}{URL of file to be downloaded.}

\item{dir}{Directory where to download the file.}

\item{fname}{Base name of the downloaded file (\code{dir} will be prefixed).}

\item{overwrite}{Whether to overwrite? Default is \code{FALSE}.}

\item{mode}{See parameter of \code{\link[=download.file]{download.file()}}.
Default of "wb" seems useful for Windows systems.}

\item{timeout}{Number of seconds before timeout. Default is 300 (5 minutes),
or \code{getOption("timeout")} when larger.}

\item{...}{
  Arguments passed on to \code{\link[utils:download.file]{utils::download.file}}
  \describe{
    \item{\code{method}}{Method to be used for downloading files.  Current
    download methods are \code{"internal"}, \code{"libcurl"},
    \code{"wget"}, \code{"curl"} and \code{"wininet"} (Windows
    only), and there is a value \code{"auto"}: see \sQuote{Details} and
    \sQuote{Note}.

    The method can also be set through the option
    \code{"download.file.method"}: see \code{\link{options}()}.
  }
    \item{\code{quiet}}{If \code{TRUE}, suppress status messages (if any), and
    the progress bar.}
    \item{\code{cacheOK}}{logical.  Is a server-side cached value acceptable?}
    \item{\code{extra}}{character vector of additional command-line arguments for
    the \code{"wget"} and \code{"curl"} methods.}
    \item{\code{headers}}{named character vector of additional HTTP headers to
    use in HTTP[S] requests.  It is ignored for non-HTTP[S] URLs.  The
    \code{User-Agent} header taken from the \code{HTTPUserAgent} option
    (see \code{\link{options}}) is automatically used as the first header.}
  }}
}
\value{
Path to the downloaded (or existing) file.
}
\description{
Download file if does not exist yet.
}
\examples{
download_file("https://github.com/privefl.png")
download_file("https://github.com/privefl.png")
download_file("https://github.com/privefl.png", overwrite = TRUE)

}
