% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/play_epic.R
\name{play_epic}
\alias{play_epic}
\title{Play through an epic quest of a tower}
\usage{
play_epic(
  ai,
  tower = c("beginner"),
  warrior_name = "Fisher",
  level_output = TRUE,
  sleep = getOption("rwarrior.sleep", ifelse(interactive(), 0.6, 0))
)
}
\arguments{
\item{ai}{AI function to control your warrior.}

\item{tower}{Tower to attempt.}

\item{warrior_name}{Name of your warrior, for flavor.}

\item{level_output}{A logical denoting whether to give individual level progress.}

\item{sleep}{Time between text updates. Set to "prompt" to only progress when pressing the return key.}
}
\value{
A tibble if successful, or otherwise FALSE.

A tibble giving the scores for each level passed.
}
\description{
Write a single AI function to play through each level of the specified tower.
Refine your AI in order to achieve an overall S rank.
}
\examples{
AI <- function(warrior, memory) {
  if(is.null(memory)) {
    # set memory initial values here
  }
  # Modify the following section to be able to complete the tower
  warrior$walk()
  memory
}
play_epic(AI, tower = "beginner", warrior_name = "Euler")
}
