% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_partition.R
\name{block_partition}
\alias{block_partition}
\title{Construct 1d block partition}
\usage{
block_partition(x, L)
}
\arguments{
\item{x}{(noisy) wc at a given scale.}

\item{L}{block size.}
}
\value{
\code{out} partition of coefficients by block.
}
\description{
This function is used to group the coefficients into blocks (or groups) of size L.
}
\examples{
x <- MakeSignal('Ramp', 8)
j0 <- 0
qmf <- MakeONFilter('Haar')
wc <- FWT_PO(x, j0, qmf)
L <- 2
wcb <- block_partition(wc, L)
}
\seealso{
\code{\link{invblock_partition}}, \code{\link{BlockThresh}}.
}
