% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_xyData.R
\name{read_xyData}
\alias{read_xyData}
\title{Import xy-Data for Supported Formats into R}
\usage{
read_xyData(file, options = "", verbose = TRUE, metaData = TRUE)
}
\arguments{
\item{file}{\link{character} (\strong{required}): path and file to be imported. The argument accepts an \code{URL}.
Can be \link{character} vector or a \link{list} of \code{characters}.}

\item{options}{\link{character} (with default): set format options (see \link{rxylib-package})}

\item{verbose}{\link{logical} (\emph{with default}): enables/disables verbose mode}

\item{metaData}{\link{logical} (\emph{with default}): enables/disables the export of metadata}
}
\value{
The functions returns a \link{list} of matrices.
}
\description{
The function provides access to the underlying \code{xylib} to import data for supported file formats
into R. In most cases, only the file path is needed with further arguments to import the data.
The function automatically recognises allowed formats. See \link{rxylib-package} for supported formats.
}
\section{Function version}{
 0.3.0
}

\examples{

##load example dataset
file <- system.file("extdata/ExampleSpectrum.CNF", package = "rxylib")
results <- read_xyData(file)
results

##plot xy-spectrum
plot(results,
 type = "l",
 xlab = "Energy [keV]",
 ylab = "Counts",
 main = "Thorite - 1800 s")

mtext(side = 3, "Canberra Inspector 1000, 3 x 3 NaI probe")

##plot contour for TL-spectrum
##imported from an XSYG-file
spectrum <- read_xyData(system.file("extdata/TLSpectrum.xsyg", package = "rxylib"))
contour(
 x = spectrum$dataset[[1]]$data_block[,1],
 y = 1:ncol(spectrum$dataset[[1]]$data_block[,-1]),
 z = spectrum$dataset[[1]]$data_block[,-1],
 xlab = "Wavelength [nm]",
 ylab = "#Channel",
 main = "TL Spectrum")

}
\author{
Sebastian Kreutzer, Institute of Geography, Ruprecht-Karl-University of Heidelberg (Germany), Johannes Friedrich,
University of Bayreuth (Germany)
} 

\section{How to cite}{
Kreutzer, S., Friedrich, J., 2024. read_xyData(): Import xy-Data for Supported Formats into R. Function version 0.3.0. In: Kreutzer, S., Friedrich, J., 2024. rxylib: Import XY-Data into R . R package version 0.2.14.9000-2. https://r-lum.github.io/rxylib/
}

\keyword{IO}
