% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LatentForests.R
\name{LatentForests}
\alias{LatentForests}
\title{Construct a poset of gaussian latent forest models.}
\usage{
LatentForests(numLeaves = 0, E = matrix(numeric(0), ncol = 2))
}
\arguments{
\item{numLeaves}{the number of observed variables (these are the leaves of
the model)}

\item{E}{a 2xm matrix of edges corresponding to the edges of the 'super
forest' f for which we compute all subforests. f should have nodes
1:numLeaves as leaves of the forest with no internal nodes as leaves.}
}
\value{
An object representing the collection.
}
\description{
For a fixed binary forest where all leaves represent observed variables this
function creates an object representing all gaussian latent forest models
that are submodels of the given model. All models are enumerated from 1 to
the total number of subforests, see the method \code{\link{getSupport.LatentForests}}
for details on how to determine which model a particular model number
corresponds to. Models are naturally ordered by inclusion so that, for
example, the forest that has no edges is less than all other models.
}

