% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_matrix.R
\name{split_matrix}
\alias{split_matrix}
\title{Split a matrix by rows, based on either the number of rows per group
or number of splits.}
\usage{
split_matrix(mat, rowspergroup = NULL, nsplits = NULL, shuffle = TRUE)
}
\arguments{
\item{mat}{A matrix to be split.}

\item{rowspergroup}{Number of rows in a group.}

\item{nsplits}{Number of splits to make.}

\item{shuffle}{Should the splits be shuffled before returning?}
}
\value{
A list of the splits of the matrix.
}
\description{
Split a matrix by rows, based on either the number of rows per group
or number of splits.
}
\examples{
mat <- matrix(1:12, ncol=2)
split_matrix(mat, 4, shuffle=FALSE)
split_matrix(mat, 4, shuffle=TRUE)
split_matrix(mat, nsplits=3, shuffle=FALSE) # same as 4 rowspergroup
}
