% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparseFn_MT.R
\name{sparseCV_MT}
\alias{sparseCV_MT}
\title{sparseCV_MT: internal cross-validation functions. For internal package use only.}
\usage{
sparseCV_MT(
  data,
  tune.grid,
  hoso = "hoso",
  method = "L0",
  nfolds = "K",
  juliaFnPath = NA,
  messageInd = FALSE,
  LSitr = 50,
  LSspc = 1,
  maxIter = 2500
)
}
\arguments{
\item{data}{Matrix with outcome and design matrix}

\item{tune.grid}{A data.frame of tuning values}

\item{hoso}{String specifying tuning type}

\item{method}{Sting specifying regression method}

\item{nfolds}{String or integer specifying number of folds}

\item{juliaFnPath}{String specifying path to Julia binary}

\item{messageInd}{Boolean for message printing}

\item{LSitr}{Integer specifying do <LSitr> local search iterations on parameter values where we do actually do LS; NA does no local search}

\item{LSspc}{Integer specifying number of hyperparameters to conduct local search: conduct local search every <LSspc>^th iteration. NA does no local search}

\item{maxIter}{Integer specifying max iterations of coordinate descent}
}
\value{
A list (S3 class) with elements used for cross validation. \item{best}{ A dataframe with the hyperparameters associated with the best prediction performance and summary statistics of performance.}
\item{best.1se}{ A dataframe including optimal hyperparameters according to 1-standard deviation rule.}  \item{rmse}{ A dataframe with prediction performance for hyperparamters in tuning grid for all folds.}
\item{avg}{ A dataframe with average performance at each of the hyperparameters in tuning grid (averaged across tasks).}
}
\description{
sparseCV_MT: internal cross-validation functions. For internal package use only.
}
