% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filiter.R
\name{Countfiliter}
\alias{Countfiliter}
\title{Filitering low expressed miRNAs based on count: Countfiliter}
\usage{
Countfiliter(P1_count, P2_count, F1_count, count_threshold = 5)
}
\arguments{
\item{P1_count}{A dataframe. The count data of miRNA from the P1 species. The first column must be the miRNA sequence. Others are listed as the count of miRNA, and each column denotes one biological replicate of the sample.}

\item{P2_count}{A dataframe. Similar with P1_count, the count data of miRNA from the P2 species.}

\item{F1_count}{A dataframe. Similar with P1_count, the count data of miRNA from the F1 species.}

\item{count_threshold}{A numeric. In all samples, there is at least one sample whose count value is more than or equal to count_threshold to be retained. By default, the count value more than or equal to 5 is retained.}
}
\value{
A dataframe. The result includes all miRNAs that fulfill the count value requirement (count >= count_threshold) in at least one sample.
}
\description{
Filitering low expressed miRNAs based on count: Countfiliter
}
\examples{
##Get the filitered mirna count table (default: Count >= 5 in at least one sample)
Count5result <- Countfiliter(P1_count = P1_miRNA_count,
                             P2_count = P2_miRNA_count,
                             F1_count = F1_miRNA_count,count_threshold = 5)
}
