% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alfabetaEB.R
\name{alphabetaEB}
\alias{alphabetaEB}
\title{Estimates alpha and beta parameter to obtain EB estimator}
\usage{
alphabetaEB(data.dir, pcap, method, opt, maxiter, tol)
}
\arguments{
\item{data.dir}{Direct estimates of the data from function pcapdir}

\item{pcap}{weighted sample mean and variance from function pcapdir}

\item{method}{Method to estimate alpha and beta parameter according to person(rao or claire)}

\item{opt}{Method to estimate alpha and beta parameter according to the way of calculation (moment or nr)}

\item{maxiter}{the Maximum iteration value}

\item{tol}{Tolerance error value at iteration}
}
\value{
This function returns a data frame with following objects :
\item{alpha_cap}{an alpha estimator by user's choice method}
\item{beta_cap}{an beta estimator by user's choice method}
}
\description{
Estimates alpha and beta parameter to obtain EB estimator
}
\examples{
## load dataset with no weight value
data(dataEB)
temp = pcapdir(dataEB[,-c(3)])
## estimates alpha and beta parameter
## in EB estimate with Moment method by J.N.K.Rao
alphabetaEB(data.dir = temp$direst ,pcap = temp$pcap,
method = "rao", opt = "moment",maxiter = 100,tol = 0.00001)

##load dataset with weight value
data(dataEB)
temp = pcapdir(dataEB)
## estimates alpha and beta parameter
## in EB estimate with Moment method by Claire E.B.O.
alphabetaEB(data.dir = temp$direst ,pcap = temp$pcap,
method = "claire", opt = "moment",maxiter = 100,tol = 0.00001)

}
