% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mse_saekernel.R
\name{mse_saekernel}
\alias{mse_saekernel}
\title{Small Area Estimation Non-Parametric Based Nadaraya-Watson Kernel and Bootstrap Mean Squared Error Estimators}
\usage{
mse_saekernel(X, Y, vardir, bandwidth, B = 1000)
}
\arguments{
\item{X}{Auxiliary Variable of X}

\item{Y}{Direct Estimation of Y}

\item{vardir}{Sampling Variances of Direct Estimators}

\item{bandwidth}{The kernel Bandwidth Smoothing Parameter}

\item{B}{Number of Bootstrap. Default is 1000}
}
\value{
This function returns a list with following objects:
\item{est}{a value of Small Area Estimation Non-Parametric Based Nadaraya-Watson Kernel}
\item{refvar}{Estimated Random Effect Variance}
\item{mse}{Bootstrap Mean Squared Error Estimators of Small Area Estimation Non-Parametric Based Nadaraya-Watson Kernel}
}
\description{
This Function Gives Small Area Estimation Non-Parametric Based Nadaraya-Watson Kernel and Calculates The Bootstrap Mean Squared Error Estimates
}
\examples{
##load dataset
data(Data_saekernel)

mse_saekernel(X = Data_saekernel$x, Y = Data_saekernel$y,
vardir = Data_saekernel$Vardir, bandwidth = 0.04, B = 1000)

}
