% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaemixData-methods_covariates.R
\name{transformContCov}
\alias{transformContCov}
\alias{transform.SaemixData}
\title{Transform continuous covariates}
\usage{
transformContCov(
  object,
  covariate,
  transformation = function(x) x,
  centering = "median",
  na.rm = TRUE,
  newCovName = "",
  verbose = FALSE
)
}
\arguments{
\item{object}{saemixData object}

\item{covariate}{the name of the covariate to transform (without quotes)}

\item{transformation}{function used to apply the transformation (can be a name, eg log or exp, or a function, see examples). Defaults to no transformation}

\item{centering}{string, giving the value used to center the covariate; can be "mean" or "median", in which case this value will be computed from the data, 'none' or 0 for no centering, or a value given by the user. Defaults to the median value over the entire dataset (including potential duplicates). The transformation will be applied as transformation(covariate)-transformation(centering value)}

\item{na.rm}{a logical evaluating to TRUE or FALSE indicating whether NA values should be stripped before computing mean or median for centering (defaults to TRUE)}

\item{newCovName}{the name of the transformed covariate (if not given, will be set to "the name of the covariate to transform"+".mod")}

\item{verbose}{a boolean, prints messages during the execution of the function if TRUE. Defaults to FALSE.}
}
\value{
an object of class \code{"\linkS4class{SaemixData}"}
}
\description{
Transform and/or center continuous covariates
}
\details{
Transformations can only involve one covariate. More complex transformations should be performed by the user
and integrated in the data object before a call to saemixData
NA values are kept unchanged (values NA before will be NA after transformation)
Using transformContCov on an saemixData object will create or modify the trans.cov slot, to store the transformation leading
to the new covariate.
Warning: the name of the covariate must be given without quotes, to match the behaviour of the usual transform function in R.
}
\examples{
# Log-transform variable birthyear and center it to the median
  x<-saemixData(name.data=cow.saemix,name.group="cow",name.predictors=c("time"), 
      name.response="weight",
  name.covariates=c("birthyear","twin","birthrank"), 
      units=list(x="d",y="kg",covariates=c("yr","-","-")),verbose=FALSE)
  x2<-transformContCov(x,birthyear,centering="median",transformation=log,verbose=FALSE, 
      newCovName = "logYear")
  print(summary(x2@data$logYear))
# Should be the same as:
  print(summary(x@data$birthyear-median(x@data$birthyear)))
  
}
\keyword{data}
