% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zTest.R
\name{designPilotSafeZ}
\alias{designPilotSafeZ}
\title{Designs a Safe Z-Test Based on Planned Samples nPlan}
\usage{
designPilotSafeZ(
  nPlan,
  alternative = c("twoSided", "greater", "less"),
  alpha = 0.05,
  sigma = 1,
  h0 = 0,
  kappa = sigma,
  tol = 1e-05,
  paired = FALSE,
  parameter = NULL
)
}
\arguments{
\item{nPlan}{optional numeric vector of length at most 2. When provided, it is used to find the safe test
defining parameter phiS. Note that if the purpose is to plan based on nPlan alone, then both meanDiffMin
and beta should be set to NULL.}

\item{alternative}{a character string specifying the alternative hypothesis must be one of "twoSided" (default),
"greater" or "less".}

\item{alpha}{numeric in (0, 1) that specifies the tolerable type I error control --independent on n-- that the
designed test has to adhere to. Note that it also defines the rejection rule e10 > 1/alpha.}

\item{sigma}{numeric > 0 representing the assumed population standard deviation used for the test.}

\item{h0}{numeric, represents the null hypothesis, default h0=0.}

\item{kappa}{the true population standard deviation. Default kappa=sigma.}

\item{tol}{a number that defines the stepsizes between the lowParam and highParam.}

\item{paired}{logical, if \code{TRUE} then paired z-test.}

\item{parameter}{optional test defining parameter. Default set to \code{NULL}.}
}
\value{
Returns a 'safeDesign' object
\describe{
  \item{nPlan}{the sample size(s) to plan for. Provided by the user.}
  \item{parameter}{the safe test defining parameter. Here phiS.}
  \item{esMin}{\code{NULL} no minimally clinically relevant effect size provided.}
  \item{alpha}{the tolerable type I error provided by the user.}
  \item{beta}{\code{NULL}, no tolerable type II error specified.}
  \item{alternative}{any of "twoSided", "greater", "less" provided by the user.}
  \item{testType}{any of "oneSample", "paired", "twoSample" effectively provided by the user.}
  \item{paired}{logical, \code{TRUE} if "paired", \code{FALSE} otherwise.}
  \item{sigma}{the assumed population standard deviation used for the test provided by the user.}
  \item{kappa}{the true population standard deviation, typically, sigma=kappa.}
  \item{ratio}{default is 1. Different from 1, whenever testType equals "twoSample", then it defines
  ratio between the planned randomisation of condition 2 over condition 1.}
  \item{tol}{the step size between parameter values in the candidate space.}
  \item{pilot}{logical, specifying whether it's a pilot design.}
  \item{call}{the expression with which this function is called.}
}
}
\description{
Designs a safe experiment for a prespecified tolerable type I error based on planned sample size(s),
which are fixed ahead of time. Outputs a list that includes phiS, i.e., the safe test defining parameter.
}
\examples{
designPilotSafeZ(nPlan=30, alpha = 0.05)
}
