% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safetensors.R
\name{safetensors}
\alias{safetensors}
\title{Low level control over safetensors files}
\description{
Low level control over safetensors files

Low level control over safetensors files
}
\details{
Allows opening a connection to a safetensors file and query the tensor names,
metadata, etc.
Opening a connection only reads the file metadata into memory.
This allows for more fined grained control over reading.
}
\examples{
if (rlang::is_installed("torch") && torch::torch_is_installed()) {
tensors <- list(x = torch::torch_randn(10, 10))
temp <- tempfile()
safe_save_file(tensors, temp)
f <- safetensors$new(temp, framework = "torch")
f$get_tensor("x")
}

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{con}}{the connection object with the file}

\item{\code{metadata}}{an R list containing the metadata header in the file}

\item{\code{framework}}{the framework used to return the tensors}

\item{\code{args}}{additional arguments for tensor creation}

\item{\code{max_offset}}{the largest offset boundary that was visited. Mainly
used in torch to find the end of the safetensors file.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-safetensors-new}{\code{safetensors$new()}}
\item \href{#method-safetensors-keys}{\code{safetensors$keys()}}
\item \href{#method-safetensors-get_tensor}{\code{safetensors$get_tensor()}}
\item \href{#method-safetensors-clone}{\code{safetensors$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-safetensors-new"></a>}}
\if{latex}{\out{\hypertarget{method-safetensors-new}{}}}
\subsection{Method \code{new()}}{
Opens the connection with the file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{safetensors$new(path, ..., framework)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path to the file to load}

\item{\code{...}}{(any)\cr
Additional, framework dependent, arguments to pass to use when creating the tensor.
For torch, this is the device, for pjrt the client.}

\item{\code{framework}}{Framework to load the data into. Currently supports "torch" and "pjrt"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-safetensors-keys"></a>}}
\if{latex}{\out{\hypertarget{method-safetensors-keys}{}}}
\subsection{Method \code{keys()}}{
Get the keys (tensor names) in the file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{safetensors$keys()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-safetensors-get_tensor"></a>}}
\if{latex}{\out{\hypertarget{method-safetensors-get_tensor}{}}}
\subsection{Method \code{get_tensor()}}{
Get a tensor from its name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{safetensors$get_tensor(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the tensor to load}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-safetensors-clone"></a>}}
\if{latex}{\out{\hypertarget{method-safetensors-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{safetensors$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
