% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estm.R
\name{estm}
\alias{estm}
\title{Sample size for estimating single mean}
\usage{
estm(mean, sig, prec, alp, relative = FALSE)
}
\arguments{
\item{mean}{anticipated population mean (required if relative precision is desired otherwise not required)}

\item{sig}{anticipated population standard deviation}

\item{prec}{desired level of precision on either side of the population mean}

\item{alp}{level of significance or accepted level of probability of type I error}

\item{relative}{a logical argument indicating relative or absolute precision (\code{FALSE} gives absolute precision)}
}
\value{
number needed to estimate mean within the desired precision level
}
\description{
This function computes adequate sample size based on the method of
estimating mean with absolute or relative precision. It can be used for descriptive studies
where the researcher wishes to describe the distribution of one or more quantitative outcome variables
without looking at their causal relationship and hypothesis testing.
}
\examples{
estm(sig=6.3,prec=1.2,alp=0.05,relative=FALSE)
estm(mean=14,sig=8,prec=0.1,alp=0.05,relative = TRUE)
}
\references{
Lwanga, S. K., Lemeshow, S., & World Health Organization. (1991). Sample size determination in health studies: a practical manual. World Health Organization.
}
\author{
R. Amala, Scientist-C, ICMR-VCRC, Puducherry  & G. Kumarapandiyan, Asst. Prof., Madras Christian College, Chennai
}
