% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_variable_labels.R
\name{check_variable_labels}
\alias{check_variable_labels}
\title{Check Variable Labels for Saros Use}
\usage{
check_variable_labels(
  data,
  separator = " - ",
  special_chars = "[^\\\\p{L}\\\\p{N}\\\\s!?'#\%&/()\\\\[\\\\]{}=+\\\\-*.,:;]"
)
}
\arguments{
\item{data}{Data frame or tibble.}

\item{separator}{String, indicating what to check that there is maximum of 1 of per label.}

\item{special_chars}{String of regular expression.}
}
\value{
Data frame
}
\description{
Checks various label quality issues and returns a data frame with indications of which label has the issue and what issue.
}
\examples{
df <- data.frame(
  a = 1:3,
  b = 4:6,
  c = 7:9,
  d = 11:13,
  e = 14:16,
  f = 17:19
)
attr(df$a, "label") <- "Age"
attr(df$b, "label") <- "Age"
attr(df$c, "label") <- "Gender - Male"
attr(df$e, "label") <- "Gender - Male -  2"
attr(df$f, "label") <- "Gender - Female..."
check_variable_labels(df)
}
