% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob.ordered.verdicts.R
\name{prob.ordered.verdicts}
\alias{prob.ordered.verdicts}
\title{Absorption probabilities for ordered-category jury models}
\usage{
prob.ordered.verdicts(jury_n, verdict_options, digits = NULL, collab = TRUE)
}
\arguments{
\item{jury_n}{Integer. Number of jurors.}

\item{verdict_options}{Character vector of ordered verdict labels
(e.g., `c("NG","Lesser","G")`). Order matters: left = most lenient.}

\item{digits}{Integer. Number of digits to round in the returned matrix.
Default `3`.}

\item{collab}{Logical. If `TRUE` (default), attach human-friendly row/column
labels: rows are verdict names; columns are starting states (transients
first, then unanimities).}
}
\value{
A numeric K by T+K matrix of absorption probabilities.
  Rows index absorbing verdicts in `verdict_options`. Columns index starting
  states: first all transient compositions, then each unanimity composition
  (one per verdict). If `collab = TRUE`, row/column names are added.
}
\description{
Compute the probability that an ordered-category Markov chain on jury vote
counts will eventually absorb at each unanimous verdict, starting from any
transient (non-unanimous) composition. Internally, this constructs the
transition matrix with `transition.matrix.ordered()` **using its defaults**,
i.e., equal cut lines (no lambda weighting).
}
\details{
Let \eqn{P} be the transition matrix returned by
`transition.matrix.ordered(jury_n, verdict_options)`, with meta attributes
providing:
- `T`: number of transient states,
- `K`: number of absorbing states (equal to `length(verdict_options)`),
- `states`: list of length `T + K` of count vectors (per state),
- `n`: the jury size,
- `verdict_options`: the verdict labels.
}
\examples{
library(sate)

# Three-verdict ordered model with a 12-person jury:
prob.ordered.verdicts(12, c("NG", "M2", "M1"))

# Probability of ultimately unanimous "Lesser" starting from A=6, B=4, C=2:
prob.ordered.verdicts(12, c("A","B","C"), digits = 3)

}
\seealso{
[transition.matrix.ordered]
}
