% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsblnorm.r
\name{dsblnorm}
\alias{dsblnorm}
\title{Size biased log-normal probability density}
\usage{
dsblnorm(x, lmean, lsig, log = FALSE, xlog = FALSE)
}
\arguments{
\item{x}{A vector of positive numbers.}

\item{lmean}{The mean of the distribution on the log scale.}

\item{lsig}{The standard deviation of the distribution on the log scale.}

\item{log}{A logical indicating whether to return log densities.}

\item{xlog}{A logical indicating whether to return densities for log
transformed data.}
}
\value{
A vector of probability densities.
}
\description{
Calculates size biased log-normal probability density - the underlying
log-normal probability density when the likelihood of recording an
observation is proportional to its value.
}
\examples{
  data(BCI_speed_data)
  agoutiData <- subset(BCI_speed_data, species=="agouti")
  dsblnorm(agoutiData$speed, 0, 0.1)
}
