% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_newdata.r
\name{make_newdata}
\alias{make_newdata}
\title{Make new data for prediction}
\usage{
make_newdata(formula, data, newdata = NULL)
}
\arguments{
\item{formula}{A two-sided formula of the form
\code{response ~ covariate + ...}}

\item{data}{A dataframe containing the fields named in formula.}

\item{newdata}{A dataframe of covariate values with fields matching variables
in \code{formula}.}
}
\value{
A dataframe of covariate values.
}
\description{
Creates or converts a dataframe of covariates to pass to
\code{\link{predict.sbm}}, based on the \code{data} used in the model to be
used for prediction.
}
\details{
When \code{newdata} is missing, a new dataframe is created with
 numeric variables held at their mean values, and all combinations of factors.
 When a \code{newdata} dataframe is provided it is checked for compatibility
 with \code{formula} variables, and character variables are converted to factors,
 but otherwise passed unchanged.
}
\examples{
  data(BCI_speed_data)
  make_newdata(speed ~ species, BCI_speed_data)
}
