% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scdeco.cop.R
\name{scdeco.cop}
\alias{scdeco.cop}
\title{Copula dynamic correlation fitting function}
\usage{
scdeco.cop(
  y,
  x,
  marginals,
  w = NULL,
  n.mcmc = 10000,
  burn = 1000,
  thin = 1,
  offset1 = NULL,
  offset2 = NULL
)
}
\arguments{
\item{y}{2-column matrix of observations}

\item{x}{covariates}

\item{marginals}{length-2 vector with strings of the two marginals}

\item{w}{(optional)}

\item{n.mcmc}{number of mcmc iterations to run}

\item{burn}{how many of the mcmc iterations to burn}

\item{thin}{how much to thin the mcmc iterations}

\item{offset1}{(optional) offset for link(mu1)}

\item{offset2}{(optional) offset for link(mu2)}
}
\value{
matrix with mcmc samples as rows and columns corresponding to the different parameters
}
\description{
Copula dynamic correlation fitting function
}
\examples{
n <- 1000
x.use = rnorm(n)
w.use = runif(n,-1,1)
eta1.use = c(-2.2, 0.7)
eta2.use = c(-2, 0.8)
beta1.use = c(1,0.5)
beta2.use = c(1,1)
alpha1.use = 7
alpha2.use = 3
tau.use = c(-0.2, .3)

marginals.use <- c("ZINB", "ZIGA")

y.use <- scdeco.sim.cop(marginals=marginals.use, x=x.use,
                    eta1.true=eta1.use, eta2.true=eta2.use,
                    beta1.true=beta1.use, beta2.true=beta2.use,
                    alpha1.true=alpha1.use, alpha2.true=alpha2.use,
                    tau.true=tau.use, w=w.use)
mcmc.out <- scdeco.cop(y=y.use, x=x.use, marginals=marginals.use, w=w.use,
                      n.mcmc=10, burn=0, thin=1) # n.mcmc=1000, burn=100, thin=5)

lowerupper <- t(apply(mcmc.out, 2, quantile, c(0.025, 0.5, 0.975)))
estmat <- cbind(lowerupper[,1],
                c(eta1.use, eta2.use, beta1.use, beta2.use, alpha1.use, alpha2.use, tau.use),
                lowerupper[,c(2,3)])
colnames(estmat) <- c("lower", "trueval", "estval", "upper")
estmat

}
