% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_profile.R
\name{scMetaTraj_cluster_profile}
\alias{scMetaTraj_cluster_profile}
\title{Summarize metabolic profiles of clusters}
\usage{
scMetaTraj_cluster_profile(
  scores,
  metabolic_cluster,
  stat = c("median", "mean"),
  scale = TRUE
)
}
\arguments{
\item{scores}{Numeric matrix, cells x pathways.}

\item{metabolic_cluster}{Factor or character vector, length = nrow(scores).}

\item{stat}{Character. "median" (default) or "mean".}

\item{scale}{Logical. Whether to z-score pathways across clusters.}
}
\value{
A data.frame: clusters x pathways.
}
\description{
scMetaTraj_cluster_profile() computes representative metabolic
pathway activities for each metabolic cluster.
}
