% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scROSHI-package.R, R/scROSHI.R
\docType{package}
\name{scROSHI}
\alias{scROSHI}
\title{Robust Supervised Hierarchical Identification of Single Cells}
\usage{
scROSHI(
  sce_data,
  celltype_lists,
  type_config,
  count_data = "normcounts",
  gene_symbol = "SYMBOL",
  cell_scores = FALSE,
  min_genes = 5,
  min_var = 1.5,
  n_top_genes = 2000,
  n_nn = 5,
  thresh_unknown = 0.05,
  thresh_uncert = 0.1,
  thresh_uncert_second = 0.8,
  verbose = 0,
  output = "sce"
)
}
\arguments{
\item{sce_data}{A SingleCellExperiment object containing the expression
profiles of the single cell analysis.}

\item{celltype_lists}{Marker gene list for all cell types. It can be provided
as a list of genes with cell types as names or as a path to a file containing the
marker genes. Supported file formats are .gmt or .gmx files.}

\item{type_config}{Config file to define major cell types and hierarchical subtypes.
It should be provided as a two-column data.frame where the first column are the
major cell types and the second column are the subtypes. If several subtypes exists,
they should be separated by comma.}

\item{count_data}{Assay name in the SingleCellExperiment object containing the count data.}

\item{gene_symbol}{Variable name in the row data of the SingleCellExperiment object containing the gene names.}

\item{cell_scores}{Boolean value determining if the scores should be saved.}

\item{min_genes}{scROSHI filters out non-unique genes as long as more than min_genes
are left. If there is a cell type that has less than min_genes genes, it will be
replaced with the cell type list BEFORE filtering for unique genes (default 5).}

\item{min_var}{Minimum variance for highly variable genes (default 1.5).}

\item{n_top_genes}{Maximum number of highly variable genes (default 2000).}

\item{n_nn}{Number of nearest neighbors for umap for assignment of cell types
(default 5).}

\item{thresh_unknown}{If none of the probabilities is above this threshold,
the cell type label is assigned to the class unknown (default 0.05).}

\item{thresh_uncert}{If the ratio between the largest and the second largest
probability is below this threshold, the cell type label is assigned to the
class uncertain for the major cell types (default 0.1).}

\item{thresh_uncert_second}{If the ratio between the largest and the second largest
probability is below this threshold, the cell type label is assigned to the
class uncertain for the subtypes (default 0.8).}

\item{verbose}{Level of verbosity. Zero means silent, one makes a verbose output.}

\item{output}{Defines the output. sce: The output is a SingleCellExperiment
object with the cell types appended to the meta data. df: The output id a
data.frame with two columns. The first column contains the barcode of the cell
and the second column contains the cell type labels.}
}
\description{
Identifying cell types based on expression profiles is a pillar of single cell analysis.

scROSHI identifies cell types based on expression profiles of single cell analysis by
utilizing previously obtained cell type specific gene sets. It takes into account the
hierarchical nature of cell type relationship and does not require training or
annotated data.
}
\examples{
\donttest{
data("test_sce_data")
data("config")
data("marker_list")

results <- scROSHI(sce_data = test_sce_data,
                   celltype_lists = marker_list,
                   type_config = config)
table(results$celltype_final)
}
}
