% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterPlotMatrix.R
\name{changeMouseMode}
\alias{changeMouseMode}
\title{Set mouse interaction type}
\usage{
changeMouseMode(id, interactionType)
}
\arguments{
\item{id}{Output variable to read from (id which references the requested plot).}

\item{interactionType}{Type of mouse interaction.}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
Three types of mouse interactions are available (\code{tooltip}, \code{filter} or \code{zoom}).
}
\examples{
 if(interactive() && require(shiny)) {
   library(shiny)
   library(scatterPlotMatrix)

   ui <- fluidPage(
     selectInput(
       "mouseMode",
       "Mouse Interactions:",
       c("Tooltip" = "tooltip", "Filter" = "filter", "Zoom" = "zoom")
     ),
     p("Selector controls type of mouse interactions with the scatterPlotMatrix"),
     scatterPlotMatrixOutput("spMatrix")
   )

   server <- function(input, output, session) {
     output$spMatrix <- renderScatterPlotMatrix({
       scatterPlotMatrix(iris)
     })
     observe({
       scatterPlotMatrix::changeMouseMode("spMatrix", input$mouseMode)
     })
   }

   shinyApp(ui, server)
 }

}
