% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distribution.R
\name{select_events}
\alias{select_events}
\title{Function to select simulated perimeters}
\usage{
select_events(
  event_sizes,
  event_probabilities,
  target_hist,
  bins,
  reference_surface,
  surface_threshold,
  tolerance,
  max_it = 5,
  iter_limit = 1e+05,
  logaritmic = TRUE
)
}
\arguments{
\item{event_sizes}{Numeric vector of surface values for all available
simulated events.}

\item{event_probabilities}{Numeric vector of probabilities corresponding to each event in `event_surfaces`.
These probabilities are used to influence the selection of events within each bin.}

\item{target_hist}{Numeric vector representing the density of the target histogram distribution.}

\item{bins}{Numeric vector of bin breakpoints used for classifying event surfaces and calculating histograms.}

\item{reference_surface}{Numeric value representing the total target surface area that the selected events should approximate.}

\item{surface_threshold}{Numeric value between 0 and 1. The selection process
continues until the cumulative surface area of selected events is at least
`reference_surface * surface_threshold`.}

\item{tolerance}{Numeric value. A tolerance level for the final discrepancy. (Note:
the current implementation finds the best discrepancy, not necessarily stopping
once tolerance is met, but aims for the minimum).}

\item{max_it}{Integer for the maximum number of iterations for the inner loop (default: 100).}

\item{iter_limit}{Integer for the maximum number of iterations in selection (default: 100000).}

\item{logaritmic}{Logical. If `TRUE`, a logarithmic transformation is applied
to `event_surfaces` before binning and to `selected_surfaces` for histogram
calculations (default: `TRUE`).}
}
\value{
A list containing the best selection found across all iterations:
  \describe{
    \item{selected_surfaces}{Numeric vector of surface values of the events in the best selection.}
    \item{surface_index}{Integer vector of the original indices (from `event_surfaces`)
      of the events in the best selection.}
    \item{total_surface}{Numeric value. The sum of surface areas of the events in the best selection.}
    \item{final_discrepancy}{Numeric value. The relative discrepancy between the
      selected events' distribution and the target histogram for the best selection.}
  }
  Returns `NULL` if no valid selection could be made (e.g., no valid results after iterations).
}
\description{
Selects a subset of simulated fire perimeters by matching their surface
distribution to a predefined target histogram. The selection is iterative
and probabilistic, aiming to minimize the discrepancy while accumulating
a total surface area above a certain threshold (e.g., mean annul burned area).
}
\seealso{
\code{\link[=vignette]{Selecting Simulated Fire Events}}
}
