% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{gini_table}
\alias{gini_table}
\title{Performance measure table with Gini coefficient, KS-statistics and Gini lift curve}
\usage{
gini_table(base, target, col_pred = F, model = F, brk = F,
  quantile_pt = 10, event_rate_direction = "decreasing")
}
\arguments{
\item{base}{input dataframe}

\item{target}{column / field name for the target variable to be passed as string (must be 0/1 type)}

\item{col_pred}{(optional) column name which contains the predicted value, not required if "model"=TRUE (default value is FALSE)}

\item{model}{(optional) object of type lm or glm model, required only if "col_pred"=FALSE (default value is FALSE)}

\item{brk}{(optional) array of break points of predicted value (default value is FALSE)}

\item{quantile_pt}{(optional) number of quantiles to divide the predicted value range (default value is 10)}

\item{event_rate_direction}{(optional) directionality of event rate with increasing value of predicted column, to be chosen among "increasing" or "decreasing" (default value is decreasing)}
}
\value{
An object of class "gini_table" is a list containing the following components:

\item{prediction}{base with the predicted value as a dataframe}

\item{gini_tab}{gini table as a dataframe}

\item{gini_value}{gini coefficient value}

\item{gini_plot}{gini curve plot}

\item{ks_value}{Kolmogorov-Smirnov statistic}

\item{breaks}{break points}
}
\description{
The function takes a dataframe along with a model or the name of a column with predicted value. If a model (only lm or glm works is guaranted to work perfectly) is provided as argument, the response on the data is predicted. Otherwise, if the data already contains a predicted column, it can be referred as an argument. The predicted column, thus obtained, is classified into bands to get the Gini coefficient, Kolmogorov-Smirnov statistics and Gini lift curve. The number of bands required can be passed as argument, with default value as 10 ie. decile binning is done. Otherwise, the cutpoints for converting the predicted value into bands can also be specified.
}
\examples{
data <- iris
data$Species <- as.character(data$Species)
suppressWarnings(RNGversion('3.5.0'))
set.seed(11)
data$Y <- sample(0:1,size=nrow(data),replace=TRUE)
suppressWarnings(RNGversion('3.5.0'))
set.seed(11)
data$Y_pred <- sample(300:900,size=nrow(data),replace=TRUE)
gini_tab_list <- gini_table(base = data,target = "Y",col_pred = "Y_pred",quantile_pt = 10)
gini_tab_list$prediction
gini_tab_list$gini_tab
gini_tab_list$gini_value
gini_tab_list$gini_plot
gini_tab_list$ks_value
gini_tab_list$breaks
}
\author{
Arya Poddar <aryapoddar290990@gmail.com>

Aiana Goyal <aianagoel002@gmail.com>
}
