% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_dm_dthfl_dthdtc.R
\name{check_dm_dthfl_dthdtc}
\alias{check_dm_dthfl_dthdtc}
\title{Check that when DM.DTHFL is Y, DM.DTHDTC does not have a missing value, and vice versa}
\usage{
check_dm_dthfl_dthdtc(DM)
}
\arguments{
\item{DM}{Demographics SDTM dataset with variables USUBJID,DTHFL,DTHDTC}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check is bi-directional for consistency of DM.DTHFL and DM.DTHDTC and returns a data
frame. Note there is a possible valid scenario for this issue if death date is truly unknown
}
\examples{

DM <- data.frame(
 USUBJID = 1:7,
 DTHFL = 1:7,
 DTHDTC = 1:7
)

DM$DTHFL[1] = ""
DM$DTHDTC[1] = "2020-01-01"
DM$DTHFL[2] = "N"
DM$DTHDTC[2] = "2020-01-01"
DM$DTHFL[3] = "Y"
DM$DTHDTC[3] = "2020-01-01"
DM$DTHFL[4] = "Y"
DM$DTHDTC[4] = ""
DM$DTHFL[5] = "N"
DM$DTHDTC[5] = ""
DM$DTHFL[6] = "Y"
DM$DTHDTC[6] = "2020"
DM$DTHFL[7] = ""
DM$DTHDTC[7] = ""
check_dm_dthfl_dthdtc(DM)

DM$DTHFL <- NULL
DM$DTHDTC <- NULL
check_dm_dthfl_dthdtc(DM)

}
\author{
Ross Farrugia
}
