% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ex_exdose_exoccur.R
\name{check_ex_exdose_exoccur}
\alias{check_ex_exdose_exoccur}
\title{Check for Missing EXDOSE.}
\usage{
check_ex_exdose_exoccur(EX, drug = NULL)
}
\arguments{
\item{EX}{Exposure SDTM dataset with variables USUBJID, EXTRT, EXSTDTC,
EXDOSE, and optional variable EXOCCUR and optional variable VISIT}

\item{drug}{Drug name for EXTRT; used to subset the dataset.
Default value is NULL (i.e. no filtering by drug)}
}
\value{
Boolean value for whether the check passed or failed, with 'msg'
attribute if the test failed
}
\description{
This checks looks for missing EXDOSE values when EXOCCUR="Y"
or when EXOCCUR does not exist.
It could be for a specified drug/treatment, or for all drugs/treatments
in the dataset
}
\examples{

EX <- data.frame(
 USUBJID = 1:3,
 EXSEQ   = 1:3,
 EXSTDTC = 1:3,
 EXTRT   = c(1,2,NA),
 EXOCCUR = "Y",
 EXDOSE  = 1:3,
 VISIT = c("CYCLE 1 DAY 1", "CYCLE 2 DAY 1", "CYCLE 3 DAY 1")
)

check_ex_exdose_exoccur(EX)

EX$EXDOSE[3]=NA
check_ex_exdose_exoccur(EX)

EX$EXVISIT = NULL
check_ex_exdose_exoccur(EX)

EX$EXDOSE = NULL
check_ex_exdose_exoccur(EX)


}
\author{
Will Harris, Pasha Foroudi
}
