% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ex_infusion_exstdtc_exendtc.R
\name{check_ex_infusion_exstdtc_exendtc}
\alias{check_ex_infusion_exstdtc_exendtc}
\title{Check that an infusion drug has same start/end exposure dates, also including missing start/end dates}
\usage{
check_ex_infusion_exstdtc_exendtc(EX)
}
\arguments{
\item{EX}{Exposure SDTM dataset with variables USUBJID,EXTRT,EXSTDTC,EXENDTC,EXROUTE}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check identifies that an infusion drug has same EXSTDTC and EXENDTC dateparts.
If time is available for both dates, also check that end time is after start time.
Missing start/end dates are also included.
}
\examples{

EX <- data.frame(
 STUDYID = 1,
 USUBJID = 1:12,
 EXTRT = "SOME DRUG",
 EXROUTE = "INTRAVENOUS",
 EXSTDTC = c("2017-01-01","2017-01-02","2017-01-01T14:36","2015","2017-02","2017"      ,""    ,
             "2017"   ,"2017-01-01T14:26","2017-01-01T14:26","2017-01-01T14","2017-01-01T14:26:01")
             ,
 EXENDTC = c("2017-01-01","2017-01-03","2017-01-01T14:35","2017","2017-01","2016-01-01","2000",
             "2017-02","2017-01-01"      ,"2017-01","2017-01-01T13","2017-01-02T14:26:02")
             ,
 EXOCCUR = "Y",
 VISIT = "CYCLE 1 DAY 1",
 stringsAsFactors=FALSE
)

 check_ex_infusion_exstdtc_exendtc(EX)

 EX2 <- data.frame(
 STUDYID = 1,
 USUBJID = 1:4,
 EXTRT = "SOME DRUG",
 EXROUTE = "INTRAVENOUS",
 EXSTDTC = c("2017-01-03", "", "2017-02-01T14:26", ""),
 EXENDTC = c("", "2017-02-03", "", "2017-02-02T14:26:02"),
 EXOCCUR = "Y",
 VISIT = "CYCLE 1 DAY 1",
 stringsAsFactors = FALSE
 )

 check_ex_infusion_exstdtc_exendtc(EX2)

 EX3 <- data.frame(
     STUDYID = 1,
     USUBJID = 1:3,
     EXTRT = "SOME DRUG",
     EXROUTE = "INTRAVENOUS",
     EXSTDTC = c("2017-01-01", "2017-01-01T14:26", "2017-01-01T14:26"),
     EXENDTC = c("2017-01-01", "2017-01-01", "2017-01"),
     EXOCCUR = "Y",
     VISIT = "CYCLE 1 DAY 1",
     stringsAsFactors=FALSE
 )

 check_ex_infusion_exstdtc_exendtc(EX3)

}
\author{
Anastasiia Khmelnytska, Stella Banjo(HackR 2021)
}
