% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_cm_cmlat.R
\name{check_cm_cmlat}
\alias{check_cm_cmlat}
\title{Check if ocular concomitant medication has laterality missing or laterality field is
populated but route is not eye-related.}
\usage{
check_cm_cmlat(CM, preproc = identity, ...)
}
\arguments{
\item{CM}{Concomitant Medications Dataset for Ophtho Study with variables
USUBJID, CMCAT, CMLAT, CMDECOD, CMTRT, CMROUTE, CMSPID (if Present), CMSTDTC (if Present)}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
This check assesses CMCAT = "CONCOMITANT MEDICATIONS" and flags potential
ocular records with missing/inconsistent route and laterality: for eye-related
CMROUTE ('INTRAVITREAL', 'OPHTHALMIC', etc.), CMLAT is not populated -or- CMROUTE is not eye-related
(i.e., not INTRAVITREAL, OPHTHALMIC, TOPICAL, etc.) but CMLAT is LEFT/RIGHT/BILATERAL.
}
\examples{

CM <- data.frame(
   USUBJID = 1:7,
   CMCAT = "CONCOMITANT MEDICATIONS",
   CMSTDTC = 1:7,
   CMLAT   = c("Left", "","Bilateral", "", "", "LEFT", ""),
   CMTRT  = c("A", "B", "A", "B", "A", "A", "B"),
   CMDECOD = c("A", "B", "A", "B", "A", "A", "B"),
   CMROUTE = c("","OPHTHALMIC","INTRAVITREAL","INTRAVITREAL",
               "opHTHALMIC", "INTRaOCULAr", "INTRaOCULAr"),
   CMSPID  = "FORMNAME-R:13/L:13XXXX",
   stringsAsFactors = FALSE)
check_cm_cmlat(CM,preproc=roche_derive_rave_row)

CM <- data.frame(
   USUBJID = 1:5,
   CMCAT = rep("CONCOMITANT MEDICATIONS",5),
   CMSTDTC = 1:5,
   CMLAT   = c("Left", "LEFT","Bilateral",
               "RIGHT", "RIgHT"),
   CMTRT  = c("A", "B", "A", "B", "A"),
   CMDECOD = c("A", "B", "A", "B", "A"),
   CMROUTE = c("","OPHTHALMIC","INTRAVITREAL",
               "INTRaOCULAr", "opHTHALMIC"),
   stringsAsFactors = FALSE)
check_cm_cmlat(CM)

CM <- data.frame(
   USUBJID = 1:5,
   CMCAT = "CONCOMITANT MEDICATIONS",
   CMSTDTC = 1:5,
   CMLAT   = c("Left", "LEFT","Bilateral", "RIGHT", "RIgHT"),
   CMTRT  = c("A", "B", "A", "B", "A"),
   CMDECOD = c("A", "B", "A", "B", "A"),
   #CMROUTE = c("","OPHTHALMIC","INTRAVITREAL","INTRaOCULAr", "opHTHALMIC"),
   stringsAsFactors = FALSE)
check_cm_cmlat(CM)

}
\seealso{
Other OPHTH: 
\code{\link{check_ae_aelat}()},
\code{\link{check_cm_cmlat_prior_ocular}()},
\code{\link{check_oe_bcva_1m_late_early_tot}()},
\code{\link{check_oe_bcva_4m_late_early_tot}()},
\code{\link{check_oe_bcva_4m_vs_1m_req}()},
\code{\link{check_oe_bcva_tot_mismatch}()},
\code{\link{check_oe_sc_lat_count_fingers}()},
\code{\link{check_pr_prlat}()},
\code{\link{check_sc_dm_eligcrit}()},
\code{\link{check_sc_dm_seyeselc}()}
}
\author{
Monarch Shah (HackR 2021 Team Eye)
}
\concept{OPHTH}
\keyword{OPHTH}
