% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_cm_missing_month.R
\name{check_cm_missing_month}
\alias{check_cm_missing_month}
\title{Check for conmed dates with year and day known but month unknown}
\usage{
check_cm_missing_month(CM, preproc = identity, ...)
}
\arguments{
\item{CM}{Concomitant Medications SDTM dataset with variables USUBJID, CMTRT,
CMSTDTC, CMENDTC}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
Check for missing month when conmed start (CMSTDTC) or end dates
(CMENDTC) have known year and day
}
\examples{

CM <- data.frame(
 USUBJID = 1:3,
 CMTRT = c("CM1","CM2","CM3"),
 CMSTDTC = c("2017-01-01","2017---01","2017-01-02"),
 CMENDTC = c("2017-02-01","2017-03-01","2017---01"),
 CMSPID = "/F:XXX-D:12345-R:123",
 stringsAsFactors=FALSE
)

check_cm_missing_month(CM)
check_cm_missing_month(CM,preproc=roche_derive_rave_row)

CM$CMSTDTC = NULL

check_cm_missing_month(CM)

}
\author{
Chandra Mannem
}
