% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_qs_qsdtc_visit_ordinal_error.R
\name{check_qs_qsdtc_visit_ordinal_error}
\alias{check_qs_qsdtc_visit_ordinal_error}
\title{Check that all QS dates are duplicated or earlier than last
visit's (possible datetime data entry error)}
\usage{
check_qs_qsdtc_visit_ordinal_error(QS)
}
\arguments{
\item{QS}{SDTM dataset with variables USUBJID, QSCAT, QSORRES, VISITNUM, VISIT, QSDTC}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check identifies QSDTC values that are duplicated or
earlier than last visit's. Unscheduled visits are excluded.
}
\examples{

# no case
QS1 <- data.frame(USUBJID = c(rep(101, 5), rep(102, 5)),
                QSCAT = "DLQI",
                QSDTC = rep(c("2017-01-01T08:25", "2017-01-05T09:25",
                 "2017-01-15T10:25","2017-01-20T08:25","2017-01-25T08:25"), 2),
                VISITNUM = rep(1:5,2),
                VISIT = rep(c( "Visit 1", "Visit 2", "Visit 3", "UNSCheduled!!!","VIsit 5"), 2),
                stringsAsFactors = FALSE)

QS2 = QS1
QS2$QSCAT = "SKINDEX-29"

QS <- rbind(QS1, QS2)
check_qs_qsdtc_visit_ordinal_error(QS)

# adding cases with earlier date
QS$QSDTC[QS$USUBJID == 101 & QS$VISIT == "Visit 3"] <- "2017-01-10T08:25"
QS$QSDTC[QS$USUBJID == 102 & QS$VISIT == "Visit 2"] <- "2017-01-01T06:25"
check_qs_qsdtc_visit_ordinal_error(QS)

# adding cases with duplicated date
QS$QSDTC[QS$USUBJID == 102 & QS$VISIT == "Visit 3"] <- "2017-01-01T06:25"
 check_qs_qsdtc_visit_ordinal_error(QS)

}
\author{
Simon Luo
}
