% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ss_ssdtc_alive_dm.R
\name{check_ss_ssdtc_alive_dm}
\alias{check_ss_ssdtc_alive_dm}
\title{Check non-missing last ALIVE status date in SS is before than death date in DM}
\usage{
check_ss_ssdtc_alive_dm(SS, DM)
}
\arguments{
\item{SS}{Subject Status SDTM dataset with variables USUBJID, SSDTC, SSORRES, SSTESTCD, VISIT}

\item{DM}{Demographics SDTM dataset with variables USUBJID, DTHDTC}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for non-missing SS.SSDTC when SS.SSORRES contains 'ALIVE' and
Subject Status Date/Time of Assessments is greater then
Start Date/Time of Disposition Event(SS.SSDTC > DS.DSSTDTC)
}
\examples{

SS <- data.frame(
 USUBJID = 1:5,
 SSDTC = "2020-01-02",
 SSTESTCD = "SURVSTAT",
 SSORRES  = c("DEAD","DEAD","ALIVE","DEAD","ALIVE"),
 VISIT = "WEEK 4"
)


DM <- data.frame(
 USUBJID = 1:5,
 DTHDTC = "2020-01-03"
)

check_ss_ssdtc_alive_dm(SS, DM)

SS <- data.frame(
 USUBJID = 1:5,
 SSDTC = "2020-01-04",
 SSTESTCD = "SURVSTAT",
 SSORRES  = c("DEAD","DEAD","ALIVE","DEAD","ALIVE"),
 VISIT = "WEEK 4"
)

DM <- data.frame(
 USUBJID = 1:5,
 DTHDTC = c("2020-01-04", "2020-01-05", "2020-01-03", "2020-01-04", "2020-01-05")
)

check_ss_ssdtc_alive_dm(SS, DM)

}
\author{
Vira Vrakina
}
