% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_tr_trstresn_ldiam.R
\name{check_tr_trstresn_ldiam}
\alias{check_tr_trstresn_ldiam}
\title{Check for TR records with missing TRSTRESN for Longest Diameter (LDIAM)}
\usage{
check_tr_trstresn_ldiam(TR, preproc = identity, ...)
}
\arguments{
\item{TR}{Tumor Results SDTM dataset with variables USUBJID, TRTESTCD,
TRLINKID/TRLNKID, TRDTC, VISIT, TRORRES, TRSTRESN, TREVAL (optional),
TRSTAT (optional), TRSPID (optional)}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
Boolean value for whether the check passed or failed, with 'msg'
attribute if the check failed
}
\description{
This checks looks for TR records with missing values in numeric
result/finding for the Longest Diameter (TRTESTCD is LDIAM) tumor measurement.
Only applies to assessments by investigator, selected based on uppercased
TREVAL = "INVESTIGATOR" or missing or TREVAL variable does not exist.
}
\examples{

TR <- data.frame(USUBJID = 1:5,
                 TRTESTCD = c("OTHER", rep("LDIAM", 4)),
                 TRLINKID = 1:5,
                 TRDTC = 1:5,
                 VISIT = LETTERS[1:5],
                 TRORRES = LETTERS[1:5],
                 TRSTRESN = 1:5,
                 TRSTAT = "",
                 TREVAL = "INVESTIGATOR",
                 TRSPID = "FORMNAME-R:19/L:19XXXX",
                 stringsAsFactors = FALSE)

check_tr_trstresn_ldiam(TR)

TR1 <- TR
TR1$TRSTAT <- NULL
TR1$TREVAL <- NULL
TR1$TRSPID <- NULL

check_tr_trstresn_ldiam(TR1)

TR2 <- TR
TR2$TRSTRESN <- c("", "NA", NA, 1, 1)

check_tr_trstresn_ldiam(TR2)
check_tr_trstresn_ldiam(TR2,preproc=roche_derive_rave_row)


}
\author{
Will Harris
}
